#!/usr/bin/env python3
# Verify Manifest - Check if all files are in manifest

import xml.etree.ElementTree as ET
from pathlib import Path

manifest_file = Path(__file__).parent / 'manifests' / 'manifest_v9032.xml'

if not manifest_file.exists():
    print("❌ Manifest not found!")
    exit(1)

tree = ET.parse(manifest_file)
root = tree.getroot()

files = []
for elem in root.findall('ContentFile'):
    name = elem.get('Name')
    sha256 = elem.get('SHA256Hash')
    files.append((name, sha256))

print(f"📋 Manifest contains {len(files)} files\n")

# Check critical files
critical = [
    'CoreRT.dll', 'v8.dll', 'scripting.dll', 'adhesive.dll',
    'avutil-56.dll', 'avcodec-58.dll', 'avformat-58.dll',
    'voip-mumble.dll'
]

print("Critical files:")
for cf in critical:
    found = any(cf.lower() in name.lower() for name, _ in files)
    status = "✅" if found else "❌"
    print(f"  {status} {cf}")

print("\nAll files:")
for name, sha256 in sorted(files):
    print(f"  {name} -> {sha256[:16]}...")
